import UIKit
extension ViewController
{
    func rotateAction (touch: UITouch, view: UIView) -> CGFloat {
        
        let curPoint = touch.location(in: view)
        let prePoint = touch.previousLocation(in: view)
        
        let center = view.center
        
        let curY = center.y - curPoint.y
        let curX = center.x - curPoint.x
        
        let preY = center.y - prePoint.y
        let preX = center.x - prePoint.x
        
        let curAngle = atan2(curY, curX)
        let preAngle = atan2(preY, preX)
        
        return curAngle - preAngle
    }
}
